<?php
/**
 * Hello Model for Hello World Component
 * 
 * @package    Joomla.Tutorials
 * @subpackage Components
 * @link http://docs.joomla.org/Developing_a_Model-View-Controller_(MVC)_Component_for_Joomla!2.5_-_Part_07
 * @license		GNU/GPL
 */

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

// import the Joomla modellist library
jimport('joomla.application.component.modellist');

/**
 * Hello sportactivities Model
 *
 * @package    Joomla.Tutorials
 * @subpackage Components
 */
class sportactivitiesModelsportactivities extends JModelList
{

	/**
	 * Method to set the hello identifier
	 *
	 * @access	public
	 * @param	int Hello identifier
	 * @return	void
	 */
	function setId($id)
	{
		// Set id and wipe data
		$this->_id		= $id;
		$this->_data	= null;
	}
	
	public function getTable($type = 'sport', $prefix = 'sportactivitiesTable', $config = array()) 
	{
		return JTable::getInstance($type, $prefix, $config);
	}
	

	/**
	 * Method to build an SQL query to load the list data.
	 *
	 * @return	string	An SQL query
	 */
	protected function getListQuery()
	{
		// Create a new query object.		
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
		// Select all fields
		$query->select('*');
		// From the __sport table
		$query->from('#__sport');
    // Add the list ordering clause.
    $query->order($db->getEscaped($this->getState('list.ordering', 'datum')) . ' ' . $db->getEscaped($this->getState('list.direction', 'DESC')));		
		return $query;
	}
	
	public function delete($cids = array())
  {
    $ids = (count($cids) > 0) ? $cids : JRequest::getVar( 'cid', array(0), 'post', 'array' );

 		$db =& JFactory::getDBO();
		$row =& $this->getTable('Sport');
 		$modelTeilnehmer = JModel::getInstance('sportteilnehmer', 'sportactivitiesModel', array('ignore_request' => true));

    foreach ($ids as $id) {
      //Hole zuerst die Teilnehmer
      $query = 'SELECT id FROM #__sport_teilnehmer where sport_id='.$id;     		
   		$db->setQuery( $query );
      $cids_t = $db->loadAssocList();
  
  		if (!$row->delete( $id )) {
  			$this->setError( $row->getErrorMsg() );
  			return false;
  		} 
      else {
        //Wenn lschen der Aktivitt erfolgreich lsche Teilnehmer
        foreach($cids_t as $cid) {
   		     if(!$modelTeilnehmer->delete($cid['id'])) 
            $this->setError( 'ERROR DELETE MEMBER' );
        }
      }
    }    

  }
  
  
  
	/**
	 * Method to delete all record(s) with an outdated date
	 *
	 * @access	public
	 * @return	boolean	True on success
	 */
	public function deleteAllOld()
	{
		$db =& JFactory::getDBO();

		$query = 'SELECT id FROM #__sport where datum < NOW() ORDER BY datum';
		$db->setQuery( $query );
		$cids = $db->loadAssocList();
 

    $this->delete($cids);
    /*
		if (count( $cids )) {
			foreach($cids as $cid) {
			
        //Hole zuerst die Teilnehmer
     		$query = 'SELECT id FROM #__sport_teilnehmer where sport_id='.$cid['id'];     		
 		    $db->setQuery( $query );
        $cids_t = $db->loadAssocList();

				if (!$row->delete( $cid['id'] )) {
					$this->setError( $row->getErrorMsg() );
					return false;
				} 
        else         
          {
          //Wenn lschen der Aktivitt erfolgreich lsche Teilnehmer
          foreach($cids_t as $cid) {
 		         if(!$modelTeilnehmer->delete($cid['id'])) 
              $this->setError( 'ERROR DELETE MEMBER' );
          }
        }
			}
		} */
		return true;
	}

}