<?php
/**
 * Hello View for Hello World Component
 * 
 * @package    Joomla.Tutorials
 * @subpackage Components
 * @link http://docs.joomla.org/Developing_a_Model-View-Controller_Component_-_Part_4
 * @license		GNU/GPL
 */

// No direct access to this file
defined('_JEXEC') or die('Restricted access');
 
// import Joomla view library
jimport('joomla.application.component.view');
 

class sportactivitiesViewsportactivities extends JView
{
	/**
	 * display method of sportactivities view
	 * @return void
	 **/	 
	 
  protected $items;
  protected $pagination;
  protected $state;

   /**
    * Display the view
    */
  public function display($tpl = null)
  { 
     $this->state = $this->get('State');
     //Hier alle Items
     $this->items = $this->get('Items');
     $this->pagination = $this->get('Pagination');
     
     if (count($errors = $this->get('Errors'))) {
        JError::raiseError(500, implode("\n", $errors));
        return false;
     }
         
    $this->addToolbar();
    parent::display($tpl);
  }
   
   	 
	/**
	 * Setting the toolbar specified by user rights
	 */
	protected function addToolBar() 
	{	
		$canDo = sportactivitiesHelper::getActions();
		JToolBarHelper::title(JText::_( 'Sportactivities manager' ), 'generic.png');
   
    JToolBarHelper::custom('sportteilnehmers.showMember', 'default.png', 'default_f2.png', 'COM_SPORTACTIVITIES_TOOLBAR_ACTIVITYMEMBER', true);

		if ($canDo->get('core.create')) 
		{
			JToolBarHelper::addNew('sportactivity.add', 'JTOOLBAR_NEW');
		}
		if ($canDo->get('core.edit')) 
		{
			JToolBarHelper::editList('sportactivity.edit', 'JTOOLBAR_EDIT');
		}
		if ($canDo->get('core.delete')) 
		{
			JToolBarHelper::deleteList('', 'sportactivities.delete', 'JTOOLBAR_DELETE');
      JToolBarHelper::custom('sportactivities.deleteAllOld', 'trash.png', 'trash.png', 'COM_SPORTACTIVITIES_TOOLBAR_DELETEALLOLD', false);
    }
		if ($canDo->get('core.admin')) 
		{
			JToolBarHelper::divider();
			JToolBarHelper::preferences('com_sportactivities');
		}
	}

}