<?php
/**
 * Hello View for Hello World Component
 * 
 * @package    Joomla.Tutorials
 * @subpackage Components
 * @link http://docs.joomla.org/Developing_a_Model-View-Controller_Component_-_Part_4
 * @license		GNU/GPL
 */

// No direct access to this file
defined('_JEXEC') or die('Restricted access');
 
// import Joomla view library
jimport('joomla.application.component.view');
 
/**
 * HelloWorlds View
 */
class sportactivitiesViewsportactivity extends JView
{
   /**
    * Display the view
    */
  public function display($tpl = null)
  {
		// get the Data
		$form = $this->get('Form');
		$item = $this->get('Item');

		// Check for errors.
		if (count($errors = $this->get('Errors'))) 
		{
			JError::raiseError(500, implode('<br />', $errors));
			return false;
		}
		// Assign the Data
		$this->form = $form;
		$this->item = $item;
 
		// Set the toolbar
		$this->addToolBar();
 
		// Display the template
		parent::display($tpl);

		// Set the document
		$this->setDocument();		
  }
   
	protected function addToolBar() 
	{
		$input = JFactory::getApplication()->input;
		$input->set('hidemainmenu', true);
		$isNew = ($this->item->id == 0);
		JToolBarHelper::title($isNew ? JText::_('COM_SPORTACTIVITIES_MANAGER_SPORTTEILNEHMER_CREATE')
		                             : JText::_('COM_SPORTACTIVITIES_MANAGER_SPORTTEILNEHMER_EDIT'));
		JToolBarHelper::save('sportactivity.save');
		JToolBarHelper::cancel('sportactivity.cancel', $isNew ? 'JTOOLBAR_CANCEL' : 'JTOOLBAR_CLOSE');
	}
	
	protected function setDocument() 
	{
	//Fügt die Javascript-Validierung hinzu
		$document = JFactory::getDocument();
		$document->addScript(JURI::root() . $this->get('Script'));
	}
	
	
}