<?php
/**
 * @package    Joomla.Tutorials
 * @subpackage Components
 * @link http://docs.joomla.org/Developing_a_Model-View-Controller_Component_-_Part_1#Creating_the_Entry_Point
 * @license    GNU/GPL
 */

// No direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

jimport('joomla.application.component.controller');
//jimport( 'joomla.utilities.utility' );

/**
 * Hello World Component Controller
 *
 * @package    Joomla.Tutorials
 * @subpackage Components
 */
class sportactivitiesController extends JController
{
	/**
	 * Method to display the view
	 *
	 * @access    public
	 */
	    
	function display()
	{
		$vName	= JRequest::getCmd('view', 'sportactivities');
		JRequest::setVar('view', $vName);
		//die($vName);
    //JRequest::setVar('view', 'sportactivities');
		parent::display();
		
		//return $this;
	}
	
	function submitActivity() {
		// Check for request forgeries.
		JRequest::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

		$modelActivity = JModel::getInstance('sportactivity', 'sportactivitiesModel', array('ignore_request' => true));
		$post = JRequest::get('post');

//die(krumo($post));
    //Erstelle Datenarray für Activity
    $dataActivity = array();
    $dataActivity['titel'] = $post['titel'];
    $dataActivity['datum'] = $post['datum'] . " " . $post['uhrzeit'];
    //Setze 1 falls Checkbox angeklickt wurde und email angegeben, sonst 0
    if (isset($post['benachrichtigen']) & $post['email'] != "")
      $dataActivity['benachrichtigen'] = $post['benachrichtigen'];
    else $dataActivity['benachrichtigen'] = 0;
    //hole text1 bis text10
    for($i=1; $i<11; $i++ ) {
      if(isset($post["text".$i]))
        $dataActivity["text".$i] = $post["text".$i];
    }
    
    //Erstelle Datenarray für Teilnehmer
    $dataTeilnehmer = array();
    //$dataTeilnehmer['sport_id'] = LATER
    $dataTeilnehmer['name'] = $post['name'];
    $dataTeilnehmer['email'] = $post['email'];

    $result = $modelActivity->saveActivity($dataActivity, $dataTeilnehmer);    
		// Check for errors.
		if ($return === false) {
			// Save the data in the session.
			$app->setUserState('com_sportacitivities.sportteilnehmer.data', $dataTeilnehmer);

			// Redirect back to the edit screen.
			$this->setMessage(JText::sprintf('COM_SPORTACTIVITES_SAVE_ACTIVITY_ERROR', $model->getError()), 'warning');
			$this->setRedirect(JRoute::_('index.php?option=com_sportactivities', false));
			return false;
		}


		$this->setMessage(JText::_('COM_SPORTACTIVITES_SAVE_ACTIVITY_SUCCESS'));
		$this->setRedirect(JRoute::_('index.php?option=com_sportactivities', false));

    return true;

  }


	function submitTeilnehmer() {
		// Check for request forgeries.
		JRequest::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

		// Initialise variables.
		$model = JModel::getInstance('sportteilnehmer', 'sportactivitiesModel', array('ignore_request' => true));

		// Get the user data.
		$post = JRequest::get('post');

    //Erstelle Datenarray
    $dataTeilnehmer = array();
    $dataTeilnehmer['sport_id'] = $post['sport_id'];
    $dataTeilnehmer['name'] = $post['name'];
    $dataTeilnehmer['email'] = $post['email'];

    //krumo($model->bind($dataTeilnehmer));
    $result = $model->store($dataTeilnehmer);
		// Check for errors.
		if ($result === false) {
			// Save the data in the session.
			$app->setUserState('com_sportacitivities.sportteilnehmer.data', $dataTeilnehmer);

			// Redirect back to the edit screen.
			$this->setMessage(JText::sprintf('COM_SPORTACTIVITES_SAVE_MEMBER_ERROR', $model->getError()), 'warning');
			$this->setRedirect(JRoute::_('index.php?option=com_sportactivities', false));
			return false;
		}
        
    
//################ Mailversand
    //hole Aktivitätendaten für Mailinhalt und Prüfung
		$modelActivity = JModel::getInstance('sportactivity', 'sportactivitiesModel', array('ignore_request' => true));
		$modelActivity->setState('sportactivity.id', $post['sport_id']);	    
    $aktivität = $modelActivity->getItem($post['sport_id']);

    //falls er benachrichtigt werden will (dann muss auch eine email existieren)
    if ($aktivität->benachrichtigen == 1 ) {    
      $empfaenger = $model->getInitiatorMailUser($post['sport_id']);
  
      
  		if($dataTeilnehmer['email'] != "")
        $vonEmail = $dataTeilnehmer['email'];
      else $vonEmail = "";
        
  		$vonName = $dataTeilnehmer['name'];
  		
    		//$sitename = $mainframe->getCfg( 'sitename' );
  		$config = JFactory::getConfig();
  		$sitename	= $config->get('sitename');
  		$url	= JUri::root()."index.php?option=com_sportactivities";

  		$subject = $sitename ." (".JText::_( $aktivität->titel ).')';
  		
  		$message = JText::_( 'Neuer Teilnehmer bei:' ) . "\n\n"
  							. JText::_( 'Titel' ) . ': '. $aktivität->titel . "\n"
  							. JText::_( 'Datum' ) . ': '. DateTime::createFromFormat('Y-m-d H:i:s', $aktivität->datum)->format('d.m.Y') . "\n"
  							. JText::_( 'Uhrzeit' ) . ': '. DateTime::createFromFormat('Y-m-d H:i:s', $aktivität->datum)->format('H:i') . "\n\n"
  							. JText::_( 'Teilnehmer' ) . ': '. $dataTeilnehmer['name'] . "\n";                							
  							if($dataTeilnehmer['email'] != "") $message .=JText::_( 'Email' ) . ': '. $dataTeilnehmer['email'] . "\n\n";
  		$message .= $url."\n\n"
  							. JText::_( 'Mit freundlichem Gruß' ) .", \n"
  							. $sitename ."\n";

  		$subject = html_entity_decode($subject, ENT_QUOTES);
  		$message = html_entity_decode($message, ENT_QUOTES);

      if(!empty($empfaenger->email))
      	$return = JFactory::getMailer()->sendMail($vonEmail, $vonName, $empfaenger->email, $subject, $message);

				// Check for an error.
				if ($return !== true) {
					$this->setError(JText::_('COM_SPORTACTIVITES_NEW_MEMBER_SEND_MAIL_FAILED'));
					return false;
				}      
//		krumo($vonEmail." ". $vonName." ". $empfaenger->email." ". $subject." ". $message);
//    die(krumo($return));	
      }		

			$this->setMessage(JText::_('COM_SPORTACTIVITES_SAVE_MEMBER_SUCCESS'));
			$this->setRedirect(JRoute::_('index.php?option=com_sportactivities', false));
            
      return true;
  }
  
	function submitKommentar() {
		// Check for request forgeries.
		JRequest::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

		$modelActivity = JModel::getInstance('sportactivity', 'sportactivitiesModel', array('ignore_request' => true));

		// Get the user data.
		$post = JRequest::get('post');

    $data = array();
    $data['id'] = $post['sport_id'];    
    $data['text10'] = $post['hiddenkommentar'] .'#br##br#'. $post['kommentar'];    

    $result = $modelActivity->store($data);

		// Check for errors.
		if ($result === false) {
			// Save the data in the session.
			$app->setUserState('com_sportacitivities.sportkommentar.data', $data);

			// Redirect back to the edit screen.
			$this->setMessage(JText::sprintf('COM_SPORTACTIVITES_SAVE_COMMENT_ERROR', $model->getError()), 'warning');
			$this->setRedirect(JRoute::_('index.php?option=com_sportactivities', false));
			return false;
		}

			$this->setMessage(JText::_('COM_SPORTACTIVITES_SAVE_COMMENT_SUCCESS'));
			$this->setRedirect(JRoute::_('index.php?option=com_sportactivities', false));
            
      return true;
		
	}


}