<?php
/**
 * Hello Model for Hello World Component
 * 
 * @package    Joomla.Tutorials
 * @subpackage Components
 * @link http://docs.joomla.org/Developing_a_Model-View-Controller_(MVC)_Component_for_Joomla!2.5_-_Part_07
 * @license		GNU/GPL
 */

// No direct access to this file
defined('_JEXEC') or die('Restricted access');

// import the Joomla modellist library
jimport('joomla.application.component.modelitem');

/**
 * Hello Hello Model
 *
 * @package    Joomla.Tutorials
 * @subpackage Components
 */
class sportactivitiesModelsportteilnehmer extends JModelItem
{
  protected $item;
	/**
	 * Returns a reference to the a Table object, always creating it.
	 *
	 * @param	type	The table type to instantiate
	 * @param	string	A prefix for the table class name. Optional.
	 * @param	array	Configuration array for model. Optional.
	 * @return	JTable	A database object
	 * @since	1.6
	 */
	public function getTable($type = 'sportteilnehmer', $prefix = 'sportactivitiesTable', $config = array()) 
	{
		return JTable::getInstance($type, $prefix, $config);
	}
	/**
	 * Method to get the record form.
	 *
	 * @param	array	$data		Data for the form.
	 * @param	boolean	$loadData	True if the form is to load its own data (default case), false if not.
	 * @return	mixed	A JForm object on success, false on failure
	 * @since	1.6
	 */

	protected function populateState() 
	{
		$app = JFactory::getApplication();
		// Get the message id
		$id = JRequest::getInt('id');
		$this->setState('sportteilnehmer.id', $id); 
	}

	/**
	 * Get the message
	 * @return object The message to be displayed to the user
	 */
	public function getItem() 
	{
		if (!isset($this->item)) 
		{
			$id = $this->getState('sportteilnehmer.id');
			$this->_db->setQuery($this->_db->getQuery(true)
				->from('#__helloworld as h')
				->leftJoin('#__categories as c ON h.catid=c.id')
				->select('h.greeting, h.params, c.title as category')
				->where('h.id=' . (int)$id));
			if (!$this->item = $this->_db->loadObject()) 
			{
				$this->setError($this->_db->getError());
			}
			else
			{
				// Load the JSON string
				$params = new JRegistry;
				$params->loadJSON($this->item->params);
				$this->item->params = $params;
 
				// Merge global params with item params
				$params = clone $this->getState('params');
				$params->merge($this->item->params);
				$this->item->params = $params;
			}
		}
		return $this->item;
	}


	public function getInitiatorMailUser($sport_id) 
	{
		if (!isset($this->item)) 
		{
				
			$id = $this->getState('sportteilnehmer.id');
  		$db = $this->getDbo();
  		$query = $db->getQuery(true);
  		$query->select('t.id, t.name, t.email');
   		$query->from('#__sport_teilnehmer AS t');
  		$query->where('sport_id = '.(int)$sport_id);
   		//$query->order($this->getState('list.ordering', 't.timestamp').' '.$this->getState('list.direction', 'DESC'));
			$db->setQuery($query);

				
			if (!$this->item = $db->loadObject()) 
			{
				$this->setError($db->getError());
			}
		}
		return $this->item;
	}
	
	public function store($data) {
		$row =& $this->getTable('sportteilnehmer');

		// Bind the form fields to the table
		if (!$row->bind($data)) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}

		// Store the Phoca gallery table to the database
		if (!$row->store()) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}
		return $row->id;
  }
  

}